#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion

namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_EquipmentMaintenance : BaseTest 
	{
		private DataTable _dtEquipmentMaintenance;
		private DataRow _drEquipmentMaintenance;
		
		private BOL.Equipment _tstEQ;
		private DataTable _dtEquipment; 

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtEquipment= UnitTestUtil.RunSQLGetDataTable("SELECT TOP 5 * FROM Equipment WHERE DivisionCode = '" + this.TestDivisionCode + "'");
				this._tstEQ=new BOL.Equipment(this._dtEquipment.Rows[0]);

				try
				{
					this._dtEquipmentMaintenance = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 EquipmentMaintenance.* FROM EquipmentMaintenance JOIN Equipment ON Equipment.EquipmentGuid = EquipmentMaintenance.EquipmentGuid WHERE DivisionCode = '" + this.TestDivisionCode + "'", true);
				}
				catch(BOL.BusinessObjectException)
				{
					this._dtEquipmentMaintenance=DAL.EquipmentMaintenance.GetEmptyEquipmentMaintenanceTable();
					
					this._drEquipmentMaintenance=this._dtEquipmentMaintenance.NewRow();
					this._drEquipmentMaintenance[TABLES.EquipmentMaintenance.EquipmentMaintenanceGuid]=System.Guid.NewGuid();
					this._drEquipmentMaintenance[TABLES.EquipmentMaintenance.EquipmentGuid]=this._tstEQ.EquipmentGuid;
					this._drEquipmentMaintenance[TABLES.EquipmentMaintenance.MaintenanceDate]=DateTime.Now.AddDays(-5);
					this._drEquipmentMaintenance[TABLES.EquipmentMaintenance.MaintenanceResults]="UnitTest";
					this._drEquipmentMaintenance[TABLES.EquipmentMaintenance.MaintenanceType]="UnitTest";
					this._drEquipmentMaintenance[TABLES.EquipmentMaintenance.PendingIssues]="UnitTest";
					this._drEquipmentMaintenance[TABLES.Equipment.DivisionCode]=this.TestDivisionCode;
					this._dtEquipmentMaintenance.Rows.Add(this._drEquipmentMaintenance);

					DAL.EquipmentMaintenance.Save(this._dtEquipmentMaintenance, DAL.EquipmentMaintenance.GetEmptyEquipmentMaintenanceTable(), Common.UpdateFunction.UC022_FrmMaintainEquipment);

					this.SetUp();
				}
				this.RefreshData = false;
			}

		}

		[Test]
		public void GetEmptyEquipmentMaintenanceTable_Pass()
		{
			DataTable dtTest = DAL.EquipmentMaintenance.GetEmptyEquipmentMaintenanceTable();

			//a fAILURE HERE MEANS THERE WAS A DB CHANGE
			Assert.AreEqual(8, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.EquipmentMaintenance.EquipmentMaintenanceGuid), TABLES.EquipmentMaintenance.EquipmentMaintenanceGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.EquipmentMaintenance.EquipmentGuid), TABLES.EquipmentMaintenance.EquipmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.EquipmentMaintenance.MaintenanceType), TABLES.EquipmentMaintenance.MaintenanceType);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.EquipmentMaintenance.MaintenanceDate), TABLES.EquipmentMaintenance.MaintenanceDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.EquipmentMaintenance.MaintenanceResults), TABLES.EquipmentMaintenance.MaintenanceResults);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.EquipmentMaintenance.PendingIssues), TABLES.EquipmentMaintenance.PendingIssues);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.EquipmentMaintenance.RowVersion), TABLES.EquipmentMaintenance.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.DivisionCode), TABLES.Equipment.DivisionCode);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void GetEmptyEquipmentMaintenanceTable_Fail()
		{
		}

		[Test]
		public void GetEquipmentMaintenanceByGuid_Pass()
		{
			DataTable dtTest = DAL.EquipmentMaintenance.GetEquipmentMaintenanceByGuid((Guid)this._dtEquipmentMaintenance.Rows[0][TABLES.EquipmentMaintenance.EquipmentMaintenanceGuid]);

			Assert.AreEqual(1, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(8, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.EquipmentMaintenance.EquipmentMaintenanceGuid), TABLES.EquipmentMaintenance.EquipmentMaintenanceGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.EquipmentMaintenance.EquipmentGuid), TABLES.EquipmentMaintenance.EquipmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.EquipmentMaintenance.MaintenanceType), TABLES.EquipmentMaintenance.MaintenanceType);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.EquipmentMaintenance.MaintenanceDate), TABLES.EquipmentMaintenance.MaintenanceDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.EquipmentMaintenance.MaintenanceResults), TABLES.EquipmentMaintenance.MaintenanceResults);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.EquipmentMaintenance.PendingIssues), TABLES.EquipmentMaintenance.PendingIssues);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.EquipmentMaintenance.RowVersion), TABLES.EquipmentMaintenance.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.DivisionCode), TABLES.Equipment.DivisionCode);
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void GetEquipmentMaintenanceByGuid_Fail()
		{
			DataTable dtTest = DAL.EquipmentMaintenance.GetEquipmentMaintenanceByGuid(Guid.Empty);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetEquipmentMaintenance_Pass()
		{
			DataTable dtTest = DAL.EquipmentMaintenance.GetEquipmentMaintenance();

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(8, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.EquipmentMaintenance.EquipmentMaintenanceGuid), TABLES.EquipmentMaintenance.EquipmentMaintenanceGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.EquipmentMaintenance.EquipmentGuid), TABLES.EquipmentMaintenance.EquipmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.EquipmentMaintenance.MaintenanceType), TABLES.EquipmentMaintenance.MaintenanceType);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.EquipmentMaintenance.MaintenanceDate), TABLES.EquipmentMaintenance.MaintenanceDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.EquipmentMaintenance.MaintenanceResults), TABLES.EquipmentMaintenance.MaintenanceResults);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.EquipmentMaintenance.PendingIssues), TABLES.EquipmentMaintenance.PendingIssues);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.EquipmentMaintenance.RowVersion), TABLES.EquipmentMaintenance.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.DivisionCode), TABLES.Equipment.DivisionCode);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetEquipmentMaintenance_Fail()
		{
		}

		[Test]
		public void GetEquipmentMaintenance_Guid_Pass()
		{
			DataTable dtTest = DAL.EquipmentMaintenance.GetEquipmentMaintenance((Guid)this._dtEquipmentMaintenance.Rows[0][TABLES.EquipmentMaintenance.EquipmentGuid]);
			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");

			Assert.AreEqual(8, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.EquipmentMaintenance.EquipmentMaintenanceGuid), TABLES.EquipmentMaintenance.EquipmentMaintenanceGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.EquipmentMaintenance.EquipmentGuid), TABLES.EquipmentMaintenance.EquipmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.EquipmentMaintenance.MaintenanceType), TABLES.EquipmentMaintenance.MaintenanceType);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.EquipmentMaintenance.MaintenanceDate), TABLES.EquipmentMaintenance.MaintenanceDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.EquipmentMaintenance.MaintenanceResults), TABLES.EquipmentMaintenance.MaintenanceResults);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.EquipmentMaintenance.PendingIssues), TABLES.EquipmentMaintenance.PendingIssues);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.EquipmentMaintenance.RowVersion), TABLES.EquipmentMaintenance.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Equipment.DivisionCode), TABLES.Equipment.DivisionCode);
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void GetEquipmentMaintenance_Guid_Fail()
		{
			DataTable dtTest = DAL.EquipmentMaintenance.GetEquipmentMaintenance(Guid.Empty);
		}

		[Test]
		public void Save_Pass()
		{
			this.RefreshData = true;

			DataTable dtEM=DAL.EquipmentMaintenance.GetEmptyEquipmentMaintenanceTable();
			//
			DataRow drEM = dtEM.NewRow();
			drEM[TABLES.EquipmentMaintenance.EquipmentMaintenanceGuid]=System.Guid.NewGuid();
			drEM[TABLES.EquipmentMaintenance.EquipmentGuid]=this._tstEQ.EquipmentGuid;
			drEM[TABLES.EquipmentMaintenance.MaintenanceDate]=DateTime.Now.AddDays(-5);
			drEM[TABLES.EquipmentMaintenance.MaintenanceResults]="UnitTest";
			drEM[TABLES.EquipmentMaintenance.MaintenanceType]="UnitTest";
			drEM[TABLES.EquipmentMaintenance.PendingIssues]="UnitTest";
			drEM[TABLES.Equipment.DivisionCode]=this.TestDivisionCode;
			
			dtEM.Rows.Add(drEM);
			
			bool retValue = DAL.EquipmentMaintenance.Save(dtEM.GetChanges(DataRowState.Added),dtEM.GetChanges(DataRowState.Modified),Common.UpdateFunction.UnitTests);

			Assert.AreEqual(true, retValue, "ReturnValue");
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void Save_Fail()
		{
			//Attempt to insert a duplicate row
			DataRow drEM = _dtEquipmentMaintenance.NewRow();
			drEM.ItemArray = this._dtEquipmentMaintenance.Rows[0].ItemArray;
			drEM[TABLES.EquipmentMaintenance.RowVersion] = DBNull.Value;
			_dtEquipmentMaintenance.Rows.Add(drEM);

			bool retValue = DAL.EquipmentMaintenance.Save(_dtEquipmentMaintenance.GetChanges(DataRowState.Added),_dtEquipmentMaintenance.GetChanges(DataRowState.Modified),Common.UpdateFunction.UnitTests);

			Assert.AreEqual(false, retValue, "ReturnValue");
		}

		[Test]
		public void GetMaintenanceTypes_Pass()
		{
			DataTable dtTest = DAL.EquipmentMaintenance.GetMaintenanceTypes();

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(1, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.EquipmentMaintenance.MaintenanceType), TABLES.EquipmentMaintenance.MaintenanceType);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetMaintenanceTypes_Fail()
		{
		}

	}
}

#endif
